//#include "JabberWerxCommonHelper.h"
//#include "Dependence.h"
//#include "featuresets/MeetingAccountMgrFeatureSet.h"
//#include "featuresets/DesktopSharingMgrFeatureSet.h"
//#include "featuresets/MeetingMgrFeatureSet.h"
//#include "jcfcoreutils/StringUtils.h"
//#include "csf/logger/CSFLogger.hpp"
//#include "csfunified/services/interface/PresenceServiceCapabilities.h"
//#include "csfunified/services/interface/PresenceOption.h"
//#include "csfunified/services/interface/Contact.h"
//#include "csfunified/services/interface/Presence.h"
//#include "services/impl/CMRControllerMgr.h"
//
//
//
//

#include "JabberServiceSink.h"
#include "JabberServiceProvider.h"

#include "csf/logger/CSFLogger.hpp"
#include "csfunified/services/interface/Presence.h"
#include "jcfcoreutils/StringUtils.h"
#include "services/impl/MeetingServiceObjectManager.h"
#include "services/impl/cmr/CMRControllerMgr.h"
#include "services/impl/meetingmgr/MeetingMgrControllerImplMac.h"
#include "services/impl/meetingmgr/MeetingMgrControllerImplWin.h"
#include "services/impl/account/MeetingAccountControllerImpl.h"

#ifdef WIN32
#include "sdkwrapper/win32/autoupgrade/jabber_sdk_wrap_impl.h"
#else //MAC
#include "sdkwrapper/mac/MeetingSDKWrap.h"
#endif

namespace CSFUnified
{
    static CSFLogger* JabberServiceSinkLogger = CSFLogger_getLogger("MeetingService-JabberServiceSinkLogger");
    
    JabberServiceSink::JabberServiceSink()
    {
		m_bStarted = false;
        m_bNetWork_Connect = true;
    }
    
    JabberServiceSink::~JabberServiceSink()
    {
        
    }

	void JabberServiceSink::start()
	{
		m_bStarted = true;
	}

	void JabberServiceSink::stop()
	{
		m_bStarted = false;
	}

    
    void JabberServiceSink::OnInstantMessageCommandReceived(std::string uri, std::string participantUri, InstantMessageCommandCodeEnum::InstantMessageCommandCode commandCode, std::string commandContent, std::string plaintext, std::string richtext, bool isGroupChatCmd)
    {
        
    }
    
    void JabberServiceSink::onPresenceChange(SMART_PTR_NS::shared_ptr<CSFUnified::Contact> contact)
    {
        CSFLogDebugS(JabberServiceSinkLogger, "JabberServiceSink::OnPresenceChange");
        if (contact == NULL)
        {
            CSFLogDebugS(JabberServiceSinkLogger, "JabberServiceSink::OnPresenceChange Error: contact is NULL");
            return;
        }
        PresenceStateEnum::PresenceState state = contact->getPresence()->getState();
        IMStateEnum::IMState iMState = contact->getPresence()->getInstantMessagingState();

#ifdef WIN32
		std::string JID = JabberServiceProvider::getInstance().getMyAccount();
        
        IJabberSDKWrap * pJMSDKWrap = JM_SDK_WRAP::JabberSDKWrapImpl::getInstance();
        if (NULL != pJMSDKWrap && NULL != pJMSDKWrap->getCommonEventCallback())
        {
            if (state == CSFUnified::PresenceStateEnum::PresenceState::Unavailable)
            {
                pJMSDKWrap->getCommonEventCallback()->OnUserSignOff(JCFCoreUtils::toWideString(JID));
            }
            
            //CDependence::getInstance()->GetUnifiedFactory()->getFeatureSet<DesktopSharingMgrFeatureSet>()->PreseceChange(JID);
        }
#endif
        
        CSFLogDebugS(JabberServiceSinkLogger, "JabberServiceSink::OnPresenceChange state = " << iMState);
        
        if (iMState == IMStateEnum::IMState::Offline)
        {
            fireonNetworkChanged(false);
        }
        
        if (iMState == IMStateEnum::IMState::Online)
        {
            if (!m_bNetWork_Connect)
            {
                fireonNetworkChanged(true);
            }
        }
    }
    
	void JabberServiceSink::onSignOn()
	{
#ifdef WIN32
		CSFLogDebugS(JabberServiceSinkLogger, "JabberServiceSink::OnSignOn");
		IJabberSDKWrap * pJMSDKWrap = JM_SDK_WRAP::JabberSDKWrapImpl::getInstance();
		if (NULL != pJMSDKWrap && NULL != pJMSDKWrap->getCommonEventCallback())
		{
			CSFLogDebugS(JabberServiceSinkLogger, "JabberServiceSink::OnSignOn call");
			pJMSDKWrap->getCommonEventCallback()->OnSignOn();
		}

		MeetingServiceObjectManager::getInstance().getCMRMgr()->start();
#endif
	}

	void JabberServiceSink::onSignOff()
	{
#ifdef WIN32
		CSFLogDebugS(JabberServiceSinkLogger, "JabberServiceSink::OnSignOff");
		IJabberSDKWrap * pJMSDKWrap = JM_SDK_WRAP::JabberSDKWrapImpl::getInstance();
		if (NULL != pJMSDKWrap && NULL != pJMSDKWrap->getCommonEventCallback())
		{
			CSFLogDebugS(JabberServiceSinkLogger, "JabberServiceSink::OnSignOff call");
			pJMSDKWrap->getCommonEventCallback()->OnSignOff();
		}

		MeetingServiceObjectManager::getInstance().getCMRMgr()->stop();
#endif
	}

    void JabberServiceSink::fireonNetworkChanged(bool bConnected)
    {
        CSFLogDebugS(JabberServiceSinkLogger, "JabberServiceSink::fireonNetworkChanged bConnected = " << bConnected);

		if (!m_bStarted)
		{
			CSFLogDebugS(JabberServiceSinkLogger, "JabberServiceSink::fireonNetworkChanged feature set is not start, return directly");
			return;
		}
        
        csf::ScopedReadRWLock lock(mLock);
        
        JabberServiceProvider* pJabberServiceProvider = MeetingServiceObjectManager::getInstance().getJabberServiceProvider();
        SMART_PTR_NS::shared_ptr<ServicesDispatcher> pServiceDispatcher = pJabberServiceProvider->getUnifiedFactory()->getServicesDispatcher();
        if (pServiceDispatcher != NULL)
        {
            bool bOnDispatcher = pServiceDispatcher->checkForUpdateAccess();
            if (bOnDispatcher)
            {
                m_bNetWork_Connect = bConnected;

                MeetingServiceObjectManager::getInstance().getMeetingAccountController()->networkChanged(bConnected);
                MeetingServiceObjectManager::getInstance().getMeetingMgrController()->networkChanged(bConnected);
                
#ifdef WIN32
                IJabberSDKWrap * pJMSDKWrap = JM_SDK_WRAP::JabberSDKWrapImpl::getInstance();
#else
                MeetingSDKWrap* pJMSDKWrap = MeetingSDKWrap::getInstance();
#endif
                if (NULL != pJMSDKWrap)
                {
                    pJMSDKWrap->networkChanged(bConnected);
                }
            }
            else
            {
                pServiceDispatcher->enqueue(boost::bind(&JabberServiceSink::fireonNetworkChanged, this, bConnected), "JabberServiceSink::fireonNetworkChanged");
            }
        }
    }
    
}